---
tags:
  - MOC
aliases:
  - Product Sense
  - Product Design
---

> [!INFO]- Product Manager needs to ensure 3 things to be successful
> 1. Desirability - Ensure that your product meets customer expectations. Continuously monitor product performance using metrics, customer feedback, and market trends.
> 2. Feasibility - Understand the technical feasibility of your product. This involves assessing whether the proposed features can be built within the given constraints (e.g., time, budget, technology stack).
> 3. Viability - Evaluate the business viability of your product. Consider factors such as market demand, revenue potential, and competitive landscape

- PM defines what product to build and to orchestrate what actions to take to make it successful. 
- Success is defined by user adoption, customer satisfaction and business value. 
- Great PMs are the most adaptive, they’re the glue that hold various stakeholders together to collectively achieve outcomes to be successful. The features and bugs that come out of product are reflection of features and bugs of the company culture itself. 

### [[PM Focus Areas]]
# PM Skills
### Core skills
- [[Product Discovery]]
- [[Customer feedback]]
- [[Prioritization]]
- [[Analytical Thinking]]
- [[OKR]]
- [[Product Strategy]]
- [[Types of risks in product success]]
- [[Experimentation]]
- [What do PMs at FAANG really do?](https://www.reddit.com/r/ProductManagement/s/4koBMEDLiq)
- Understand [[Tech - Old|technology]]
	- Technical knowledge for non-developers has one goal: Improve the collaboration to delivery faster and better. 
		For this, treat learning less as individual action (like: do a course, read a book) and rather as an investigation: 
		What are the blind spots in the collaboration that make us slow? 
		Is it because we have difficulties of speaking the same language often is)? 
		Or do developers lack trust in my decisions because they feel that them and there technical perspective is not reflected enough?
- [[Data Science]]
### Soft skills
[[Storytelling styles]]
[[Communication]]
[[PM Templates]]

### PM Role Expertise
[[Types of PMs]]
[[Principal Product Manager]]
[[API Product Manager]]
##### Strong PM differentiators 
1. Understands users and customers really well, knows how to do product discovery well
2. Expert in data to understand sales, usage
3. Learn different parts of the business - to understand marketing, legal, compliance and other important stakeholders
4. Know competitive landscape well
5. Use all 4 above to build strategic context and map it with company strategy and vision

[Good vs Great PMs](https://www.linkedin.com/pulse/good-product-managers-great-shreyas-doshi)
[[Shining out as great PM vs Average PM.pdf]]

##### Hardware vs software PM: 
Hardware PMs have to think a lot about physical constraints of the product starting from design and development to account for supply chain, packaging and go to market strategies. 
Hardware products taught me about how to ruthlessly focus on customer mindset in a market with so many competitor products. 
- [[Inside Out 2 - Product Manager edition.pdf]]
- [[10_Powerful_Reminders_to_a_Fuller_Life_1721595071.pdf]]
- [[Duolingo Product Handbook 2025.pdf]]

# Product Sense
### Product Design Questions
##### Design 
- [[Optimize Insta for Teenagers]]
- [[Ride sharing for seniors as Uber PM]]
- How would you build a product for Olympics 
- [[Product for farm people as Meta PM]]
- Design a product to enable people to learn a musical instrument remotely 
- You're a PM at Disney or Universal. What product would you build for its theme parks? [[Product for theme park as Disney PM]]
- Design a product for group travel
- PM for Maps (Google or Apple), [[Parking solution as Google PM]]
- Design product for art, as Meta PM
- Design a [[Product for volunteering]]. What would you build and why? 
- Design [[Video conferencing platform]]
- Improve [[Creator monetization for Horizon Worlds]] as Meta Horizon Creator success PM
- Design [[Product for home buying experience]]
- [[LinkedIn Feed]]
- Design a product to help users find contractors or handyman
- Design a product to help people learn new skills
- Build movie ticket selling app/experience for Meta
- Design product to improve in-store grocery sales
  OR Grocery store is experiencing drop in sales due to increased competition from online shopping and delivery services. Design a product to address this problem
- PM at Meta, design a product for health
- Design a product for dealing with emergency at home
- Design a product for education
- Design a gardening product as PM at Meta
- Design WhatsApp for kids
- Design a fitness product for Meta
- Design a neighborhood product for Facebook
- Design a product for new parents
- Design Netflix for kids

##### Improve
- Google maps as google PM
- Improve your [[Favorite product]] [[Favorite product]] 
- Improve Netflix
- Improve in-store experience at Ikea
- Improve DMV - department of motor vehicles

### Product design - Types of questions

Design something
- Furniture business for Airbnb
- Facebook for travel
- Alarm clock for blind
- Augmented reality glasses
- Experience of moving from one city to another

Improve something
- Improve Amazon Prime
- Amazon deals category page
- Improve Google Maps

Question types and examples to help you understand better
Strategy
1. Product Strategy: How would you increase bookings on Airbnb? (https://lnkd.in/gjX8b_ep)
2. Estimation: How many Google docs are created daily (https://lnkd.in/gFUgpPNz)
3. Prioritization: How would you prioritize WhatsApp group chat features? (https://lnkd.in/gy7RWfXz)
Approach to strategy questions: https://lnkd.in/gN3A9udy

Design
4. Product design Design a audio product for Meta (https://lnkd.in/gxtsFMRK)
5. Product improvement: Improve Google maps (https://lnkd.in/gHfDDXJU)
6. Favorite product: What's your favorite product? (https://lnkd.in/g2FtB4A3)

Analysis 
7. Metric definition: Define success metrics of dating app (https://lnkd.in/gapCYmkn)
8. Metric change YouTube traffic went down 5% — how would you report this issue to the executive team? (https://lnkd.in/gKHbyGr5)

Technical 
9. Technical explanation Explain how APIs work (https://lnkd.in/gVFDckPb)
How do Google doc works (https://lnkd.in/gmTmNfQ3)
10. Algorithm/System design (https://lnkd.in/gQ22aieM)

### Product Sense - Structure and Concepts
##### Thinking sequence 
Prompt clarification
- Understand the prompt 
- Explain the product
- Define scope, context (market, app ecosystem) and boundary conditions 
Motivation
- Explain motivation to build this product 
- Tie with overall company’s mission 
- Explain current market players, 
- Explain company’s strengths and weaknesses 
- Explain benefits to the company 
Goal
- Define goal to ensure there’s clear focus on certain outcome 
Users of ecosystem 
- Bring MECE and intent/purpose driven user segments that have substantially different needs 
- Prioritize one segment based on reach and impact to goal
Journey and pain points for the prioritized user segment 
- Bring detailed journey steps for the user 
- Identify pain points that are unique and unsolved in current product offerings 
- Prioritize on pain point that has high frequency and severity and that is still unsolved in market 
Solutions 
- Build unique solutions that are creative and with no limits 
- Think beyond existing products into future product technologies too 
- Identify risks vs benefits 
- Prioritize solutions based on high level impact vs effort analysis 
- Think how MVP of prioritized solution will work 
- Tie it back to the goal and summarize the solution. 

##### Thinking framework for Product Sense interviews
1. Goal - ask clarifying questions
    - What's our main objective?
    - Are we a startup company or a big tech firm designing this product? Understand if there are ways to leverage existing core competencies or if we have deep pockets (e.g. for Google, can leverage data. For Apple, can leverage ecosystem)
    - Do we have any insight that led us to chase this goal?
2. Layout your framework.
3. Users - identify broad user segments applicable to the company if possible, and then classify them into segments as per the problem statement.
	- Take some time to brainstorm
4. Use cases / Pain points - show customer empathy - If I am X, I would feel Y pain point.
	- Features should be thoughtful, 1 moonshot idea is nice to have
5. Summarize the design
	- Prioritization
	- Key metrics
![[Product Design framework.png]]
##### Persona
Persona definition - demographic cohort based on one or more attributes
Based on age, gender, location/geography, occupation, life event, time spent, skills, interests, physical conditions,
Broad user types:
1. Age based - Toddlers / Kids / Teenagers / Adult / Elderly
2. Profession based - Working office / Working from home / Non working or retired
3. Lifestyle based - social / select few friends and family / alone by choice
4. Type of habits -
	- Reading - Casual vs Heavy. Or artists/writers vs academicians vs book or online content readers
	- Sports pro or Athlete / Artists / knowledge workers / frontline or health workers
5. Abilities - functional human / partially disabled / fully disabled
##### Technology design types:
1. Industrial design - improves form and feel to optimize function and appearance of products
2. Interaction design - improve user’s understanding of what and how something happened. Draws inspiration from psychology, art and emotion to ensure positive experience.
3. Experience design - focus on quality and enjoyment of end to end experience
##### 10 principles of good product design:
1. Good design is innovative
2. makes a product useful. Optimizes usefulness
3. is creative
4. makes product understandable
5. is unobtrusive
6. is honest
7. is long-lasting
8. is thorough down to the last detail
9. is environmentally friendly, conserves resources
10. is simple, with as little design as possible. Less but better.

##### Aspect of usability
Definition: refers to how easy and pleasant user interfaces are to use.
1. Learnability
2. Efficiency
3. Memorability
4. Errors
5. Satisfaction
##### Design of everyday things: Don Norman
Discoverability: 5 Principles of good design
1. Affordances - Explains what all things a product can afford to do, flat surfaces are for keeping things, chair is for sitting or placing object on it or it can also be for lifting weight or hitting someone
2. Signifiers - Add cues to signify an action user should take
3. Constraints - Identify boundaries of the product’s features
4. Mappings - Map light switches in same sequence as the physical lights in the room
5. Feedback - Press light button, gives click or feedback that light is turned on

##### Design Principles: Set of considerations that form basis of a good product.
- Design Pattern exist to ease out user experience with recurring solutions to recurring problems (similar to programming)
- Ease of registration, provide lazy registration option
- Infinite scoll vs pagination
- Responsive web design: Desktop vs Mobile UX needs differ significantly due to difference of user interface
- One finger mobile layout - considers natural thumb reach on touchscreen UI and places design elements accordingly.
- Clear CTA - call to action
### PM Influencers
- [[PM networking]]
- Marty Cagan - www.svpg.com
- [[Expert tips]]
- Senior PM recruitment journey (no referrals): https://www.reddit.com/r/ProductManagement/s/LTji3PSFHs




### ChatGPT prompt on UB problems to solve
I am part of commerce platform org. I am a principal product manager managing purchase experience APIs that are known as CQP - Cart Quote Platform APIs. CQP team owns a set of microservices to enable transaction capabilities from start of transaction intent (adding a product in a quote or a cart) all the way to submitting order. 
Once order is submitted, the information is passed down to back-office microservices to fulfil the order. Back-office microservices are not part of CQP. Order fulfilment depends on the products ordered (hardware, software) and shipment specifications. 

I am an aspiring product leader and want to increase strategic and valuable contribution by differentiating myself from other product managers.

CQP APIs contain following set of API capabilities. Quote, Cart, Checkout are main entry points for UX clients to talk to our APIs. Item, Contact are child services. 
Quote and Cart APIs provide capability to create/update/delete quote. They allow adding/updating/deleting items, coupons, billing contact and customer preferences. 
Checkout APIs provide capability to add/delete payment methods and shipping information.
Item APIs provide capability to add/update/delete items with specific configuration as per user selection. 
Contact APIs provide capability to add/update/delete various types of contacts required in eCommerce transaction. For example, billing contact, shipping contact, delivery contact, installation contact. 

With this context, what type of business problems should I focus on solving using AI? 






